# ProCRM — Professional Client Relationship Manager

## Overview
A fully-featured CRM with dual panels:
- **Client Panel** — Registration, login, service purchase, order tracking
- **Admin Panel** — Client approval, order management, full service/pricing editor

---

## Quick Setup

### 1. Requirements
- PHP 7.4+
- MySQL 5.7+ / MariaDB 10+
- Apache with mod_rewrite (or Nginx)
- (Optional) Composer for PHPMailer

### 2. Database Setup
```sql
-- Import the SQL file:
mysql -u root -p < config/install.sql
```
Or run `config/install.sql` via phpMyAdmin.

### 3. Configure Database
Edit `config/database.php`:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'your_user');
define('DB_PASS', 'your_password');
define('DB_NAME', 'crm_db');
```

### 4. Web Server
Point document root to the `crm/` folder. For Apache, ensure `mod_rewrite` is enabled.

### 5. Uploads Folder
Ensure `uploads/payments/` is writable:
```bash
chmod -R 755 uploads/
```

### 6. Admin Login
- URL: `/admin/login.php`
- Email: `admin@crm.com`
- Password: `password`
> **Change the default password immediately!** Go to Admin → Settings.

---

## Features

### Client Panel
| Feature | Details |
|---------|---------|
| Registration | Name, phone, email, WhatsApp, Telegram, password |
| Login | Email + password |
| 2FA | Email code (+ WhatsApp via Twilio) |
| Password Reset | Token-based via email |
| Campaign Services | Google Ads, Meta Ads, Combo, Other Networks |
| Payment Plans | Prepay / Postpay with full T&C |
| Training Services | 5 courses with per-class pricing |
| Date Selection | Pick class dates, auto-calculate total |
| Discounts | $10/$20/$30 off training orders |
| Payment Methods | USDT or UPI |
| Screenshot Upload | Drag & drop proof upload |
| Order Tracking | Status with admin notes |
| Profile Management | Edit personal details |
| Security | Change password, toggle 2FA |

### Admin Panel
| Feature | Details |
|---------|---------|
| Dashboard | Real-time stats + pending items |
| Client Approval | Approve/Disapprove with email notification |
| Order Review | View screenshot, update status, add notes |
| Client Notification | Auto-email on status change |
| Service Editor | Add/edit/delete services with all fields |
| Pricing Control | Live price editing |
| Payment Plans | Edit T&C for prepay/postpay |
| Discount Editor | Add/edit/remove discount options |
| Categories | Add/edit service categories |
| Settings | SMTP, payment addresses, site config |

---

## Email Configuration (SMTP)
Go to **Admin → Settings** and fill in your SMTP details.

For Gmail:
- Host: `smtp.gmail.com`
- Port: `587`
- User: your Gmail address
- Pass: App-specific password (not your regular Gmail password)

---

## WhatsApp 2FA (Optional)
Requires Twilio. Add credentials in Admin → Settings:
- `twilio_sid`
- `twilio_token`  
- `twilio_whatsapp` (format: `whatsapp:+14155238886`)

---

## File Structure
```
crm/
├── admin/              Admin panel pages
├── client/             Client panel pages
├── assets/
│   ├── css/style.css   Main stylesheet
│   └── js/app.js       Main JavaScript
├── config/
│   ├── database.php    DB connection
│   └── install.sql     Database schema
├── includes/
│   ├── functions.php   Core helpers
│   ├── admin-sidebar.php
│   └── client-sidebar.php
├── uploads/payments/   Payment screenshots
├── .htaccess
└── index.php
```

---

## Security Notes
- All inputs are sanitized with `htmlspecialchars` + `strip_tags`
- Passwords hashed with `PASSWORD_DEFAULT` (bcrypt)
- Reset tokens use `random_bytes(32)` 
- Session-based auth with role checks on every page
- Sensitive directories blocked via `.htaccess`

---

## Default Credentials
| Role | Email | Password |
|------|-------|----------|
| Admin | admin@crm.com | password |

**⚠️ Change immediately after setup!**
