<?php
require_once __DIR__ . '/../includes/functions.php';
requireAdmin();
$db = getDB();

$stats = [
    'total_users'     => $db->query("SELECT COUNT(*) FROM users")->fetch_row()[0],
    'pending_users'   => $db->query("SELECT COUNT(*) FROM users WHERE status='pending'")->fetch_row()[0],
    'approved_users'  => $db->query("SELECT COUNT(*) FROM users WHERE status='approved'")->fetch_row()[0],
    'total_orders'    => $db->query("SELECT COUNT(*) FROM orders")->fetch_row()[0],
    'pending_orders'  => $db->query("SELECT COUNT(*) FROM orders WHERE status='pending'")->fetch_row()[0],
    'confirmed_orders'=> $db->query("SELECT COUNT(*) FROM orders WHERE status='confirmed'")->fetch_row()[0],
    'revenue'         => $db->query("SELECT COALESCE(SUM(total_amount),0) FROM orders WHERE status IN ('confirmed','completed')")->fetch_row()[0],
];

$recentOrders = $db->query("SELECT o.*, u.name as client_name, s.name as service_name FROM orders o
    JOIN users u ON o.user_id=u.id JOIN services s ON o.service_id=s.id
    ORDER BY o.created_at DESC LIMIT 8")->fetch_all(MYSQLI_ASSOC);

$pendingClients = $db->query("SELECT * FROM users WHERE status='pending' ORDER BY created_at DESC LIMIT 5")->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard — ProCRM</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="layout">
  <?php include __DIR__ . '/../includes/admin-sidebar.php'; ?>
  <div class="main-content">
    <div class="topbar">
      <button class="topbar-toggle" id="sidebarToggle">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
      </button>
      <span class="topbar-title">Dashboard</span>
      <div class="topbar-spacer"></div>
      <span style="font-size:13px;color:var(--text-muted)"><?= date('l, F j, Y') ?></span>
    </div>
    <div class="page">
      <?= renderFlash() ?>

      <div class="page-header">
        <h2>Admin Overview</h2>
        <p>Platform-wide metrics and recent activity.</p>
      </div>

      <div class="stats-grid">
        <div class="stat-card">
          <div class="stat-icon">👥</div>
          <div class="stat-value"><?= $stats['total_users'] ?></div>
          <div class="stat-label">Total Clients</div>
        </div>
        <div class="stat-card">
          <div class="stat-icon">⏳</div>
          <div class="stat-value"><?= $stats['pending_users'] ?></div>
          <div class="stat-label">Pending Approvals</div>
        </div>
        <div class="stat-card">
          <div class="stat-icon">✅</div>
          <div class="stat-value"><?= $stats['approved_users'] ?></div>
          <div class="stat-label">Approved Clients</div>
        </div>
        <div class="stat-card">
          <div class="stat-icon">📋</div>
          <div class="stat-value"><?= $stats['total_orders'] ?></div>
          <div class="stat-label">Total Orders</div>
        </div>
        <div class="stat-card">
          <div class="stat-icon">🔔</div>
          <div class="stat-value"><?= $stats['pending_orders'] ?></div>
          <div class="stat-label">Pending Orders</div>
        </div>
        <div class="stat-card">
          <div class="stat-icon">💰</div>
          <div class="stat-value">$<?= number_format($stats['revenue'], 0) ?></div>
          <div class="stat-label">Total Revenue</div>
        </div>
      </div>

      <div style="display:grid;grid-template-columns:1fr 380px;gap:20px">
        <div class="card">
          <div class="card-header">
            <div class="card-title">Recent Orders</div>
            <a href="/admin/orders.php" class="btn btn-outline btn-sm">All Orders</a>
          </div>
          <?php if (empty($recentOrders)): ?>
            <div class="empty-state"><div class="empty-state-icon">📦</div><div class="empty-state-desc">No orders yet.</div></div>
          <?php else: ?>
          <div class="table-wrap">
            <table>
              <thead>
                <tr><th>#</th><th>Client</th><th>Service</th><th>Amount</th><th>Status</th><th></th></tr>
              </thead>
              <tbody>
                <?php foreach ($recentOrders as $o): ?>
                <tr>
                  <td class="td-mono">#<?= str_pad($o['id'],4,'0',STR_PAD_LEFT) ?></td>
                  <td><?= htmlspecialchars($o['client_name']) ?></td>
                  <td style="font-size:13px;max-width:160px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap"><?= htmlspecialchars($o['service_name']) ?></td>
                  <td><strong>$<?= number_format($o['total_amount'],2) ?></strong></td>
                  <td><span class="badge badge-<?= $o['status'] ?>"><?= ucfirst($o['status']) ?></span></td>
                  <td><a href="/admin/orders.php?id=<?= $o['id'] ?>" class="btn btn-outline btn-sm">Review</a></td>
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <?php endif; ?>
        </div>

        <div class="card">
          <div class="card-header">
            <div class="card-title">Pending Approvals</div>
            <a href="/admin/clients.php?filter=pending" class="btn btn-outline btn-sm">All</a>
          </div>
          <?php if (empty($pendingClients)): ?>
            <div class="empty-state"><div class="empty-state-icon">✅</div><div class="empty-state-desc">No pending approvals.</div></div>
          <?php else: ?>
          <div style="display:flex;flex-direction:column;gap:10px">
            <?php foreach ($pendingClients as $c): ?>
            <div style="display:flex;align-items:center;justify-content:space-between;padding:12px;background:var(--black);border:1px solid var(--border);border-radius:8px">
              <div>
                <div style="font-weight:600;font-size:14px"><?= htmlspecialchars($c['name']) ?></div>
                <div style="font-size:12px;color:var(--text-muted)"><?= htmlspecialchars($c['email']) ?></div>
              </div>
              <div style="display:flex;gap:6px">
                <a href="/admin/clients.php?approve=<?= $c['id'] ?>" class="btn btn-success btn-sm">✓</a>
                <a href="/admin/clients.php?disapprove=<?= $c['id'] ?>" class="btn btn-danger btn-sm">✕</a>
              </div>
            </div>
            <?php endforeach; ?>
          </div>
          <?php endif; ?>
        </div>
      </div>

    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
</body>
</html>
