<?php
require_once __DIR__ . '/../includes/functions.php';
requireAdmin();
$db = getDB();

// Handle status update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['order_id'])) {
    $oid    = (int)$_POST['order_id'];
    $status = in_array($_POST['status'], ['pending','confirmed','rejected','completed']) ? $_POST['status'] : 'pending';
    $notes  = sanitize($_POST['admin_notes'] ?? '');
    $db->prepare("UPDATE orders SET status=?,admin_notes=? WHERE id=?")->bind_param('ssi',$status,$notes,$oid) && true;
    $db->prepare("UPDATE orders SET status=?,admin_notes=? WHERE id=?")->bind_param('ssi',$status,$notes,$oid)->execute();

    // Notify client
    $order = $db->query("SELECT o.*,u.email,u.name as uname,s.name as sname FROM orders o JOIN users u ON o.user_id=u.id JOIN services s ON o.service_id=s.id WHERE o.id=$oid")->fetch_assoc();
    if ($order) {
        $statusMsg = ['confirmed'=>'has been confirmed','rejected'=>'was rejected','completed'=>'is now complete'][$status] ?? "status updated to $status";
        $content = "<h2>Order Update</h2><p>Hi <strong>{$order['uname']}</strong>, your order <strong>#".str_pad($oid,4,'0',STR_PAD_LEFT)."</strong> for <em>{$order['sname']}</em> $statusMsg.</p>"
            . ($notes ? "<div class='code-box'><p style='font-size:14px;color:#aaa'>Admin Note:<br><strong style='color:#fff'>$notes</strong></p></div>" : '');
        sendEmail($order['email'], "ProCRM — Order Update", emailTemplate('Order Update', $content));
    }

    setFlash('success', 'Order updated and client notified.');
    header('Location: /admin/orders.php');
    exit;
}

// Filters
$filter = $_GET['filter'] ?? 'all';
$where  = $filter !== 'all' ? "WHERE o.status='$filter'" : '';
$search = sanitize($_GET['search'] ?? '');
if ($search) {
    $s = $db->real_escape_string($search);
    $w = "(u.name LIKE '%$s%' OR s.name LIKE '%$s%')";
    $where = $where ? "$where AND $w" : "WHERE $w";
}

$orders = $db->query("SELECT o.*, u.name as client_name, u.email as client_email, s.name as service_name, sc.name as cat_name
    FROM orders o
    JOIN users u ON o.user_id=u.id
    JOIN services s ON o.service_id=s.id
    JOIN service_categories sc ON s.category_id=sc.id
    $where ORDER BY o.created_at DESC")->fetch_all(MYSQLI_ASSOC);

// Highlight specific order if ?id=x
$highlightId = (int)($_GET['id'] ?? 0);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Orders — ProCRM Admin</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="layout">
  <?php include __DIR__ . '/../includes/admin-sidebar.php'; ?>
  <div class="main-content">
    <div class="topbar">
      <button class="topbar-toggle" id="sidebarToggle">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
      </button>
      <span class="topbar-title">Orders</span>
    </div>
    <div class="page">
      <?= renderFlash() ?>

      <div class="page-header">
        <h2>Order Management</h2>
        <p>Review, confirm, and manage all client orders.</p>
      </div>

      <div style="display:flex;flex-wrap:wrap;gap:12px;margin-bottom:20px;align-items:center">
        <form method="GET" style="flex:1;min-width:200px">
          <input type="text" name="search" class="form-control" placeholder="Search clients or services..." value="<?= htmlspecialchars($search) ?>" style="max-width:300px">
        </form>
        <div style="display:flex;gap:6px;flex-wrap:wrap">
          <?php foreach (['all','pending','confirmed','rejected','completed'] as $f): ?>
          <a href="?filter=<?= $f ?>" class="btn <?= $filter === $f ? 'btn-primary' : 'btn-outline' ?> btn-sm"><?= ucfirst($f) ?></a>
          <?php endforeach; ?>
        </div>
      </div>

      <div class="card">
        <?php if (empty($orders)): ?>
          <div class="empty-state"><div class="empty-state-icon">📦</div><div class="empty-state-title">No orders found</div></div>
        <?php else: ?>
        <div class="table-wrap">
          <table>
            <thead>
              <tr><th>#</th><th>Client</th><th>Service</th><th>Plan</th><th>Method</th><th>Amount</th><th>Status</th><th>Date</th><th>Actions</th></tr>
            </thead>
            <tbody>
              <?php foreach ($orders as $o): ?>
              <tr id="order-row-<?= $o['id'] ?>">
                <td class="td-mono">#<?= str_pad($o['id'],4,'0',STR_PAD_LEFT) ?></td>
                <td>
                  <div style="font-weight:600;font-size:14px"><?= htmlspecialchars($o['client_name']) ?></div>
                  <div style="font-size:12px;color:var(--text-muted)"><?= htmlspecialchars($o['client_email']) ?></div>
                </td>
                <td>
                  <div style="font-size:13px"><?= htmlspecialchars($o['service_name']) ?></div>
                  <div style="font-size:11px;color:var(--text-muted)"><?= htmlspecialchars($o['cat_name']) ?></div>
                </td>
                <td><?php if ($o['payment_plan']): ?><span class="badge badge-<?= $o['payment_plan'] ?>"><?= ucfirst($o['payment_plan']) ?></span><?php else: ?>—<?php endif; ?></td>
                <td style="text-transform:uppercase;font-size:12px;font-weight:600"><?= $o['payment_method'] ?></td>
                <td><strong>$<?= number_format($o['total_amount'],2) ?></strong></td>
                <td><span class="badge badge-<?= $o['status'] ?>"><?= ucfirst($o['status']) ?></span></td>
                <td style="font-size:13px;color:var(--text-muted)"><?= date('M j, Y', strtotime($o['created_at'])) ?></td>
                <td><button class="btn btn-outline btn-sm" data-modal="modal-order-<?= $o['id'] ?>">Review</button></td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
        <?php endif; ?>
      </div>

      <!-- Order Modals -->
      <?php foreach ($orders as $o): ?>
      <div class="modal-backdrop" id="modal-order-<?= $o['id'] ?>" style="display:none">
        <div class="modal" style="max-width:600px">
          <div class="modal-header">
            <div class="modal-title">Order #<?= str_pad($o['id'],4,'0',STR_PAD_LEFT) ?></div>
            <button class="modal-close" data-dismiss="modal">✕</button>
          </div>
          <div class="modal-body">
            <div style="display:grid;grid-template-columns:1fr 1fr;gap:16px;margin-bottom:20px">
              <div><div class="label-caps" style="margin-bottom:6px">Client</div><div style="font-weight:600"><?= htmlspecialchars($o['client_name']) ?></div><div style="font-size:12px;color:var(--text-muted)"><?= htmlspecialchars($o['client_email']) ?></div></div>
              <div><div class="label-caps" style="margin-bottom:6px">Service</div><div><?= htmlspecialchars($o['service_name']) ?></div><div style="font-size:12px;color:var(--text-muted)"><?= htmlspecialchars($o['cat_name']) ?></div></div>
              <?php if ($o['payment_plan']): ?><div><div class="label-caps" style="margin-bottom:6px">Plan</div><span class="badge badge-<?= $o['payment_plan'] ?>"><?= ucfirst($o['payment_plan']) ?></span></div><?php endif; ?>
              <?php if ($o['num_classes']): ?><div><div class="label-caps" style="margin-bottom:6px">Classes</div><div><?= $o['num_classes'] ?></div></div><?php endif; ?>
              <div><div class="label-caps" style="margin-bottom:6px">Payment</div><div style="text-transform:uppercase;font-weight:700"><?= $o['payment_method'] ?></div></div>
              <div><div class="label-caps" style="margin-bottom:6px">Current Status</div><span class="badge badge-<?= $o['status'] ?>"><?= ucfirst($o['status']) ?></span></div>
            </div>

            <div class="price-summary" style="margin-bottom:20px">
              <div class="price-row"><span>Subtotal</span><span>$<?= number_format($o['subtotal'],2) ?></span></div>
              <?php if ($o['discount_amount'] > 0): ?>
              <div class="price-row discount"><span>Discount</span><span>-$<?= number_format($o['discount_amount'],2) ?></span></div>
              <?php endif; ?>
              <div class="price-row divider total"><span>Total</span><span>$<?= number_format($o['total_amount'],2) ?></span></div>
            </div>

            <?php if ($o['payment_screenshot']): ?>
            <div style="margin-bottom:20px">
              <div class="label-caps" style="margin-bottom:10px">Payment Screenshot</div>
              <?php $ext = strtolower(pathinfo($o['payment_screenshot'], PATHINFO_EXTENSION)); ?>
              <?php if (in_array($ext, ['jpg','jpeg','png','gif','webp'])): ?>
                <img src="/<?= htmlspecialchars($o['payment_screenshot']) ?>" style="max-width:100%;border-radius:8px;border:1px solid var(--border)">
              <?php else: ?>
                <a href="/<?= htmlspecialchars($o['payment_screenshot']) ?>" target="_blank" class="btn btn-outline btn-sm">View Document</a>
              <?php endif; ?>
            </div>
            <?php endif; ?>

            <!-- Update Form -->
            <form method="POST">
              <input type="hidden" name="order_id" value="<?= $o['id'] ?>">
              <div class="form-group">
                <label class="form-label">Update Status</label>
                <select name="status" class="form-control">
                  <?php foreach (['pending','confirmed','rejected','completed'] as $st): ?>
                  <option value="<?= $st ?>" <?= $o['status'] === $st ? 'selected' : '' ?>><?= ucfirst($st) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="form-group">
                <label class="form-label">Admin Notes (optional)</label>
                <textarea name="admin_notes" class="form-control" placeholder="Add notes for the client..."><?= htmlspecialchars($o['admin_notes'] ?? '') ?></textarea>
              </div>
              <button type="submit" class="btn btn-primary btn-full">Save & Notify Client</button>
            </form>
          </div>
        </div>
      </div>
      <?php endforeach; ?>

    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
<?php if ($highlightId): ?>
<script>
  // Auto-open modal for highlighted order
  const el = document.getElementById('modal-order-<?= $highlightId ?>');
  if (el) el.style.display = 'flex';
</script>
<?php endif; ?>
</body>
</html>
