<?php
require_once __DIR__ . '/../includes/functions.php';
requireAdmin();
$db = getDB();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fields = ['site_name','site_email','usdt_address','upi_id','smtp_host','smtp_port','smtp_user','smtp_pass','smtp_from'];
    foreach ($fields as $f) {
        if (isset($_POST[$f])) {
            $val  = sanitize($_POST[$f]);
            $stmt = $db->prepare("INSERT INTO settings (setting_key,setting_value) VALUES (?,?) ON DUPLICATE KEY UPDATE setting_value=?");
            $stmt->bind_param('sss', $f, $val, $val);
            $stmt->execute();
        }
    }

    // Admin password change
    if (!empty($_POST['admin_password'])) {
        $newPass = $_POST['admin_password'];
        if (strlen($newPass) >= 8) {
            $hashed = password_hash($newPass, PASSWORD_DEFAULT);
            $aid    = $_SESSION['admin_id'];
            $db->query("UPDATE admins SET password='$hashed' WHERE id=$aid");
        }
    }

    setFlash('success', 'Settings saved successfully.');
    header('Location: /admin/settings.php');
    exit;
}

$settings = getSettings();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Settings — ProCRM Admin</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="layout">
  <?php include __DIR__ . '/../includes/admin-sidebar.php'; ?>
  <div class="main-content">
    <div class="topbar">
      <button class="topbar-toggle" id="sidebarToggle">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
      </button>
      <span class="topbar-title">Settings</span>
    </div>
    <div class="page">
      <?= renderFlash() ?>
      <div class="page-header"><h2>System Settings</h2><p>Configure site options, payment details, and email settings.</p></div>

      <form method="POST">
        <div style="display:grid;grid-template-columns:1fr 1fr;gap:20px;max-width:900px">

          <div class="card">
            <div class="card-header"><div class="card-title">General</div></div>
            <div class="form-group">
              <label class="form-label">Site Name</label>
              <input type="text" name="site_name" class="form-control" value="<?= htmlspecialchars($settings['site_name'] ?? 'ProCRM') ?>">
            </div>
            <div class="form-group">
              <label class="form-label">Contact Email</label>
              <input type="email" name="site_email" class="form-control" value="<?= htmlspecialchars($settings['site_email'] ?? '') ?>">
            </div>
          </div>

          <div class="card">
            <div class="card-header"><div class="card-title">Payment Details</div></div>
            <div class="form-group">
              <label class="form-label">USDT Address (TRC20)</label>
              <input type="text" name="usdt_address" class="form-control" value="<?= htmlspecialchars($settings['usdt_address'] ?? '') ?>" placeholder="TRC20 wallet address">
            </div>
            <div class="form-group">
              <label class="form-label">UPI ID</label>
              <input type="text" name="upi_id" class="form-control" value="<?= htmlspecialchars($settings['upi_id'] ?? '') ?>" placeholder="yourname@upi">
            </div>
          </div>

          <div class="card" style="grid-column:1/-1">
            <div class="card-header"><div class="card-title">Email / SMTP Configuration</div></div>
            <div class="form-row">
              <div class="form-group">
                <label class="form-label">SMTP Host</label>
                <input type="text" name="smtp_host" class="form-control" value="<?= htmlspecialchars($settings['smtp_host'] ?? 'smtp.gmail.com') ?>">
              </div>
              <div class="form-group">
                <label class="form-label">SMTP Port</label>
                <input type="number" name="smtp_port" class="form-control" value="<?= htmlspecialchars($settings['smtp_port'] ?? '587') ?>">
              </div>
            </div>
            <div class="form-row">
              <div class="form-group">
                <label class="form-label">SMTP Username</label>
                <input type="text" name="smtp_user" class="form-control" value="<?= htmlspecialchars($settings['smtp_user'] ?? '') ?>">
              </div>
              <div class="form-group">
                <label class="form-label">SMTP Password</label>
                <input type="password" name="smtp_pass" class="form-control" placeholder="Leave blank to keep current">
              </div>
            </div>
            <div class="form-group">
              <label class="form-label">From Email Address</label>
              <input type="email" name="smtp_from" class="form-control" value="<?= htmlspecialchars($settings['smtp_from'] ?? '') ?>">
            </div>
          </div>

          <div class="card">
            <div class="card-header"><div class="card-title">Admin Account</div></div>
            <div class="form-group">
              <label class="form-label">New Admin Password</label>
              <input type="password" name="admin_password" class="form-control" placeholder="Leave blank to keep current">
              <div class="form-hint">Min. 8 characters</div>
            </div>
          </div>

        </div>

        <div style="margin-top:24px">
          <button type="submit" class="btn btn-primary btn-lg">Save All Settings</button>
        </div>
      </form>
    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
</body>
</html>
