<?php
require_once __DIR__ . '/../includes/functions.php';
requireLogin();
$db  = getDB();
$uid = $_SESSION['user_id'];

$orders = $db->query("SELECT o.*, s.name as service_name, sc.name as category_name FROM orders o
    JOIN services s ON o.service_id = s.id
    JOIN service_categories sc ON s.category_id = sc.id
    WHERE o.user_id = $uid ORDER BY o.created_at DESC LIMIT 5")->fetch_all(MYSQLI_ASSOC);

$stats = [
    'total'     => $db->query("SELECT COUNT(*) FROM orders WHERE user_id=$uid")->fetch_row()[0],
    'pending'   => $db->query("SELECT COUNT(*) FROM orders WHERE user_id=$uid AND status='pending'")->fetch_row()[0],
    'confirmed' => $db->query("SELECT COUNT(*) FROM orders WHERE user_id=$uid AND status='confirmed'")->fetch_row()[0],
    'completed' => $db->query("SELECT COUNT(*) FROM orders WHERE user_id=$uid AND status='completed'")->fetch_row()[0],
];

$userName  = $_SESSION['user_name'];
$hour      = (int) date('H');
$greeting  = $hour < 12 ? 'Good morning' : ($hour < 17 ? 'Good afternoon' : 'Good evening');
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Dashboard — ProCRM</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="layout">
  <?php include __DIR__ . '/../includes/client-sidebar.php'; ?>
  <div class="main-content">
    <div class="topbar">
      <button class="topbar-toggle" id="sidebarToggle">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
      </button>
      <span class="topbar-title">Dashboard</span>
      <div class="topbar-spacer"></div>
      <a href="/client/services.php" class="btn btn-primary btn-sm">+ New Order</a>
    </div>

    <div class="page">
      <?= renderFlash() ?>

      <div style="margin-bottom:28px;">
        <h2><?= $greeting ?>, <?= htmlspecialchars(explode(' ', $userName)[0]) ?> 👋</h2>
        <p class="text-muted" style="margin-top:6px;">Here's an overview of your activity.</p>
      </div>

      <div class="stats-grid">
        <div class="stat-card">
          <div class="stat-icon">📋</div>
          <div class="stat-value"><?= $stats['total'] ?></div>
          <div class="stat-label">Total Orders</div>
        </div>
        <div class="stat-card">
          <div class="stat-icon">⏳</div>
          <div class="stat-value"><?= $stats['pending'] ?></div>
          <div class="stat-label">Pending Review</div>
        </div>
        <div class="stat-card">
          <div class="stat-icon">✅</div>
          <div class="stat-value"><?= $stats['confirmed'] ?></div>
          <div class="stat-label">Confirmed</div>
        </div>
        <div class="stat-card">
          <div class="stat-icon">🏆</div>
          <div class="stat-value"><?= $stats['completed'] ?></div>
          <div class="stat-label">Completed</div>
        </div>
      </div>

      <div class="card">
        <div class="card-header">
          <div class="card-title">Recent Orders</div>
          <a href="/client/orders.php" class="btn btn-outline btn-sm">View All</a>
        </div>
        <?php if (empty($orders)): ?>
          <div class="empty-state">
            <div class="empty-state-icon">📦</div>
            <div class="empty-state-title">No orders yet</div>
            <div class="empty-state-desc">Browse our services and place your first order.</div>
            <a href="/client/services.php" class="btn btn-primary" style="margin-top:16px">Explore Services</a>
          </div>
        <?php else: ?>
        <div class="table-wrap">
          <table>
            <thead>
              <tr>
                <th>#</th>
                <th>Service</th>
                <th>Category</th>
                <th>Plan</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Date</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($orders as $o): ?>
              <tr>
                <td class="td-mono">#<?= str_pad($o['id'], 4, '0', STR_PAD_LEFT) ?></td>
                <td><?= htmlspecialchars($o['service_name']) ?></td>
                <td><?= htmlspecialchars($o['category_name']) ?></td>
                <td><?php if ($o['payment_plan']): ?><span class="badge badge-<?= $o['payment_plan'] ?>"><?= ucfirst($o['payment_plan']) ?></span><?php endif; ?></td>
                <td><strong>$<?= number_format($o['total_amount'], 2) ?></strong></td>
                <td><span class="badge badge-<?= $o['status'] ?>"><?= ucfirst($o['status']) ?></span></td>
                <td class="text-muted"><?= date('M j, Y', strtotime($o['created_at'])) ?></td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
        <?php endif; ?>
      </div>

      <div class="card" style="margin-top:20px">
        <div class="card-header">
          <div class="card-title">Quick Actions</div>
        </div>
        <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(160px,1fr));gap:12px;">
          <a href="/client/services.php" class="card card-sm" style="display:flex;flex-direction:column;gap:8px;align-items:center;text-align:center;cursor:pointer;transition:all 0.2s">
            <div style="font-size:28px">🚀</div>
            <div style="font-weight:600;font-size:13px">New Order</div>
          </a>
          <a href="/client/orders.php" class="card card-sm" style="display:flex;flex-direction:column;gap:8px;align-items:center;text-align:center;cursor:pointer;transition:all 0.2s">
            <div style="font-size:28px">📋</div>
            <div style="font-weight:600;font-size:13px">View Orders</div>
          </a>
          <a href="/client/profile.php" class="card card-sm" style="display:flex;flex-direction:column;gap:8px;align-items:center;text-align:center;cursor:pointer;transition:all 0.2s">
            <div style="font-size:28px">👤</div>
            <div style="font-weight:600;font-size:13px">My Profile</div>
          </a>
          <a href="/client/security.php" class="card card-sm" style="display:flex;flex-direction:column;gap:8px;align-items:center;text-align:center;cursor:pointer;transition:all 0.2s">
            <div style="font-size:28px">🔐</div>
            <div style="font-weight:600;font-size:13px">Security</div>
          </a>
        </div>
      </div>
    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
</body>
</html>
