<?php
require_once __DIR__ . '/../includes/functions.php';
requireLogin();
$db  = getDB();
$uid = $_SESSION['user_id'];

$orders = $db->query("SELECT o.*, s.name as service_name, sc.name as category_name 
    FROM orders o
    JOIN services s ON o.service_id = s.id
    JOIN service_categories sc ON s.category_id = sc.id
    WHERE o.user_id = $uid
    ORDER BY o.created_at DESC")->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>My Orders — ProCRM</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="layout">
  <?php include __DIR__ . '/../includes/client-sidebar.php'; ?>
  <div class="main-content">
    <div class="topbar">
      <button class="topbar-toggle" id="sidebarToggle">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
      </button>
      <span class="topbar-title">My Orders</span>
      <div class="topbar-spacer"></div>
      <a href="/client/services.php" class="btn btn-primary btn-sm">+ New Order</a>
    </div>
    <div class="page">
      <?= renderFlash() ?>
      <div class="page-header">
        <h2>Order History</h2>
        <p>Track the status of all your orders.</p>
      </div>

      <?php if (empty($orders)): ?>
        <div class="empty-state">
          <div class="empty-state-icon">📦</div>
          <div class="empty-state-title">No orders found</div>
          <div class="empty-state-desc">You haven't placed any orders yet.</div>
          <a href="/client/services.php" class="btn btn-primary" style="margin-top:16px">Browse Services</a>
        </div>
      <?php else: ?>
        <div style="margin-bottom:16px">
          <input type="text" class="form-control" placeholder="Search orders..." data-search-table="#ordersTable" style="max-width:320px">
        </div>
        <div class="card">
          <div class="table-wrap">
            <table id="ordersTable">
              <thead>
                <tr>
                  <th>Order #</th>
                  <th>Service</th>
                  <th>Category</th>
                  <th>Plan</th>
                  <th>Method</th>
                  <th>Amount</th>
                  <th>Status</th>
                  <th>Date</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($orders as $o): ?>
                <tr>
                  <td class="td-mono">#<?= str_pad($o['id'], 4, '0', STR_PAD_LEFT) ?></td>
                  <td><?= htmlspecialchars($o['service_name']) ?></td>
                  <td><span class="text-muted" style="font-size:13px"><?= htmlspecialchars($o['category_name']) ?></span></td>
                  <td><?php if ($o['payment_plan']): ?><span class="badge badge-<?= $o['payment_plan'] ?>"><?= ucfirst($o['payment_plan']) ?></span><?php else: ?>—<?php endif; ?></td>
                  <td><span style="text-transform:uppercase;font-size:12px;font-weight:600"><?= htmlspecialchars($o['payment_method']) ?></span></td>
                  <td><strong>$<?= number_format($o['total_amount'], 2) ?></strong></td>
                  <td><span class="badge badge-<?= $o['status'] ?>"><?= ucfirst($o['status']) ?></span></td>
                  <td class="text-muted" style="font-size:13px"><?= date('M j, Y', strtotime($o['created_at'])) ?></td>
                  <td>
                    <button class="btn btn-outline btn-sm" data-modal="modal-order-<?= $o['id'] ?>">View</button>
                  </td>
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>

        <!-- Order Detail Modals -->
        <?php foreach ($orders as $o): ?>
        <div class="modal-backdrop" id="modal-order-<?= $o['id'] ?>" style="display:none">
          <div class="modal" style="max-width:580px">
            <div class="modal-header">
              <div class="modal-title">Order #<?= str_pad($o['id'], 4, '0', STR_PAD_LEFT) ?></div>
              <button class="modal-close" data-dismiss="modal">✕</button>
            </div>
            <div class="modal-body">
              <div style="display:grid;grid-template-columns:1fr 1fr;gap:16px;margin-bottom:20px">
                <div>
                  <div class="label-caps" style="margin-bottom:6px">Service</div>
                  <div style="font-weight:600"><?= htmlspecialchars($o['service_name']) ?></div>
                </div>
                <div>
                  <div class="label-caps" style="margin-bottom:6px">Category</div>
                  <div><?= htmlspecialchars($o['category_name']) ?></div>
                </div>
                <?php if ($o['payment_plan']): ?>
                <div>
                  <div class="label-caps" style="margin-bottom:6px">Payment Plan</div>
                  <span class="badge badge-<?= $o['payment_plan'] ?>"><?= ucfirst($o['payment_plan']) ?></span>
                </div>
                <?php endif; ?>
                <?php if ($o['num_classes']): ?>
                <div>
                  <div class="label-caps" style="margin-bottom:6px">Classes</div>
                  <div><?= $o['num_classes'] ?> classes</div>
                </div>
                <?php endif; ?>
                <div>
                  <div class="label-caps" style="margin-bottom:6px">Payment Method</div>
                  <div style="text-transform:uppercase;font-weight:600"><?= $o['payment_method'] ?></div>
                </div>
                <div>
                  <div class="label-caps" style="margin-bottom:6px">Status</div>
                  <span class="badge badge-<?= $o['status'] ?>"><?= ucfirst($o['status']) ?></span>
                </div>
              </div>

              <div class="price-summary" style="margin-bottom:20px">
                <div class="price-row"><span>Subtotal</span><span>$<?= number_format($o['subtotal'], 2) ?></span></div>
                <?php if ($o['discount_amount'] > 0): ?>
                <div class="price-row discount"><span>Discount</span><span>-$<?= number_format($o['discount_amount'], 2) ?></span></div>
                <?php endif; ?>
                <div class="price-row divider total"><span>Total Paid</span><span>$<?= number_format($o['total_amount'], 2) ?></span></div>
              </div>

              <?php if ($o['payment_screenshot']): ?>
              <div>
                <div class="label-caps" style="margin-bottom:10px">Payment Screenshot</div>
                <?php $ext = strtolower(pathinfo($o['payment_screenshot'], PATHINFO_EXTENSION)); ?>
                <?php if (in_array($ext, ['jpg','jpeg','png','gif','webp'])): ?>
                  <img src="/<?= htmlspecialchars($o['payment_screenshot']) ?>" style="max-width:100%;border-radius:8px;border:1px solid var(--border)">
                <?php else: ?>
                  <a href="/<?= htmlspecialchars($o['payment_screenshot']) ?>" target="_blank" class="btn btn-outline btn-sm">View PDF</a>
                <?php endif; ?>
              </div>
              <?php endif; ?>

              <?php if ($o['admin_notes']): ?>
              <div style="margin-top:16px;padding:14px;background:var(--black);border-radius:8px;border:1px solid var(--border)">
                <div class="label-caps" style="margin-bottom:6px">Admin Notes</div>
                <p style="font-size:14px;color:var(--text-muted)"><?= nl2br(htmlspecialchars($o['admin_notes'])) ?></p>
              </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      <?php endif; ?>
    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
</body>
</html>
