<?php
require_once __DIR__ . '/../includes/functions.php';
requireLogin();
$db  = getDB();
$uid = $_SESSION['user_id'];

$stmt = $db->prepare("SELECT * FROM users WHERE id=?");
$stmt->bind_param('i', $uid);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name     = sanitize($_POST['name'] ?? '');
    $phone    = sanitize($_POST['phone'] ?? '');
    $whatsapp = sanitize($_POST['whatsapp'] ?? '');
    $telegram = sanitize($_POST['telegram'] ?? '');

    if (!$name || !$phone) {
        setFlash('error', 'Name and phone are required.');
    } else {
        $stmt = $db->prepare("UPDATE users SET name=?,phone=?,whatsapp=?,telegram_id=? WHERE id=?");
        $stmt->bind_param('ssssi', $name, $phone, $whatsapp, $telegram, $uid);
        $stmt->execute();
        $_SESSION['user_name'] = $name;
        setFlash('success', 'Profile updated successfully.');
        header('Location: /client/profile.php');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Profile — ProCRM</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="layout">
  <?php include __DIR__ . '/../includes/client-sidebar.php'; ?>
  <div class="main-content">
    <div class="topbar">
      <button class="topbar-toggle" id="sidebarToggle">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
      </button>
      <span class="topbar-title">Profile</span>
    </div>
    <div class="page">
      <?= renderFlash() ?>
      <div class="page-header"><h2>My Profile</h2></div>

      <div style="max-width:600px">
        <div class="card">
          <div class="card-header"><div class="card-title">Personal Information</div></div>
          <form method="POST">
            <div class="form-row">
              <div class="form-group">
                <label class="form-label">Full Name *</label>
                <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($user['name']) ?>" required>
              </div>
              <div class="form-group">
                <label class="form-label">Phone Number *</label>
                <input type="tel" name="phone" class="form-control" value="<?= htmlspecialchars($user['phone']) ?>" required>
              </div>
            </div>
            <div class="form-group">
              <label class="form-label">Email Address</label>
              <input type="email" class="form-control" value="<?= htmlspecialchars($user['email']) ?>" disabled>
              <div class="form-hint">Email cannot be changed. Contact support if needed.</div>
            </div>
            <div class="form-row">
              <div class="form-group">
                <label class="form-label">WhatsApp Number</label>
                <input type="tel" name="whatsapp" class="form-control" value="<?= htmlspecialchars($user['whatsapp'] ?? '') ?>">
              </div>
              <div class="form-group">
                <label class="form-label">Telegram ID</label>
                <input type="text" name="telegram" class="form-control" value="<?= htmlspecialchars($user['telegram_id'] ?? '') ?>" placeholder="@username">
              </div>
            </div>
            <button type="submit" class="btn btn-primary">Save Changes</button>
          </form>
        </div>

        <div class="card" style="margin-top:20px">
          <div class="card-header"><div class="card-title">Account Status</div></div>
          <div style="display:flex;gap:12px;align-items:center">
            <span class="badge badge-<?= $user['status'] ?>" style="font-size:13px;padding:6px 14px"><?= ucfirst($user['status']) ?></span>
            <span class="text-muted" style="font-size:13px">Member since <?= date('M j, Y', strtotime($user['created_at'])) ?></span>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
</body>
</html>
