<?php
require_once __DIR__ . '/../includes/functions.php';

$page = basename($_SERVER['PHP_SELF'], '.php'); // forgot-password or reset-password
$success = $error = '';

if ($page === 'forgot-password') {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $db = getDB();
        $email = filter_var($_POST['email'] ?? '', FILTER_VALIDATE_EMAIL);
        if (!$email) { $error = 'Enter a valid email address.'; }
        else {
            $stmt = $db->prepare("SELECT * FROM users WHERE email=?");
            $stmt->bind_param('s', $email);
            $stmt->execute();
            $user = $stmt->get_result()->fetch_assoc();

            // Always show success to prevent enumeration
            $success = 'If this email exists, a reset link has been sent.';

            if ($user) {
                $token   = generateToken(32);
                $expires = date('Y-m-d H:i:s', strtotime('+1 hour'));
                $uid     = $user['id'];
                $db->query("UPDATE users SET reset_token='$token', reset_expires='$expires' WHERE id=$uid");

                $resetUrl = "http://{$_SERVER['HTTP_HOST']}/client/reset-password.php?token=$token";
                $content  = "<h2>Reset Your Password</h2>
                    <p>Hi <strong>{$user['name']}</strong>, click the button below to reset your password.</p>
                    <p><a href='$resetUrl' class='btn' style='display:inline-block;background:#fff;color:#000;padding:14px 32px;border-radius:4px;text-decoration:none;font-weight:700;font-size:14px;letter-spacing:1px;text-transform:uppercase;margin:20px 0'>Reset Password</a></p>
                    <p>This link expires in 1 hour. If you didn't request this, ignore this email.</p>
                    <p style='font-size:12px;color:#666;word-break:break-all'>Or copy: $resetUrl</p>";
                sendEmail($email, 'ProCRM — Password Reset', emailTemplate('Reset Password', $content));
            }
        }
    }
    
} elseif ($page === 'reset-password') {
    $db    = getDB();
    $token = sanitize($_GET['token'] ?? '');
    $user  = null;

    if ($token) {
        $stmt = $db->prepare("SELECT * FROM users WHERE reset_token=? AND reset_expires > NOW()");
        $stmt->bind_param('s', $token);
        $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();
    }

    if (!$user && !$success) { $error = 'Invalid or expired reset link. Please request a new one.'; }

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && $user) {
        $password = $_POST['password'] ?? '';
        $confirm  = $_POST['confirm_password'] ?? '';
        if (strlen($password) < 8) {
            $error = 'Password must be at least 8 characters.';
        } elseif ($password !== $confirm) {
            $error = 'Passwords do not match.';
        } else {
            $hashed = password_hash($password, PASSWORD_DEFAULT);
            $uid    = $user['id'];
            $db->query("UPDATE users SET password='$hashed', reset_token=NULL, reset_expires=NULL WHERE id=$uid");
            $success = 'Password updated successfully!';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= $page === 'forgot-password' ? 'Forgot Password' : 'Reset Password' ?> — ProCRM</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="auth-wrapper">
  <div class="auth-brand">
    <div class="auth-brand-logo">ProCRM</div>
    <div class="auth-brand-tagline">Account Recovery</div>
  </div>
  <div class="auth-form-area">
    <div class="auth-box">
      <div class="auth-header">
        <h2><?= $page === 'forgot-password' ? 'Forgot Password' : 'Set New Password' ?></h2>
        <p><?= $page === 'forgot-password' ? "Enter your email and we'll send a reset link." : "Enter your new password below." ?></p>
      </div>

      <?php if ($error): ?>
        <div class="flash flash-error"><span class="flash-icon">✕</span> <?= htmlspecialchars($error) ?></div>
      <?php endif; ?>

      <?php if ($success): ?>
        <div class="flash flash-success"><span class="flash-icon">✓</span> <?= htmlspecialchars($success) ?></div>
        <a href="/client/login.php" class="btn btn-outline btn-full" style="margin-top:16px">← Back to Login</a>

      <?php elseif ($page === 'forgot-password'): ?>
        <form method="POST">
          <div class="form-group">
            <label class="form-label">Email Address</label>
            <input type="email" name="email" class="form-control" placeholder="you@example.com" required autofocus>
          </div>
          <button type="submit" class="btn btn-primary btn-full">Send Reset Link</button>
          <p class="text-center text-muted mt-16" style="font-size:13px">
            <a href="/client/login.php" style="color:var(--white)">← Back to login</a>
          </p>
        </form>

      <?php elseif ($page === 'reset-password' && $user): ?>
        <form method="POST">
          <div class="form-group">
            <label class="form-label">New Password</label>
            <div style="position:relative;display:flex;align-items:center;">
              <input type="password" name="password" class="form-control" placeholder="Min. 8 characters" style="padding-right:48px" required autofocus>
              <button type="button" class="password-toggle" style="position:absolute;right:12px;background:none;border:none;color:var(--text-muted);font-size:16px;cursor:pointer;">👁</button>
            </div>
          </div>
          <div class="form-group">
            <label class="form-label">Confirm Password</label>
            <input type="password" name="confirm_password" class="form-control" placeholder="Repeat password" required>
          </div>
          <button type="submit" class="btn btn-primary btn-full">Update Password</button>
        </form>

      <?php else: ?>
        <a href="/client/forgot-password.php" class="btn btn-outline btn-full">Request New Reset Link</a>
      <?php endif; ?>

    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
</body>
</html>
