<?php
require_once __DIR__ . '/../includes/functions.php';
requireLogin();
$db  = getDB();
$uid = $_SESSION['user_id'];

$stmt = $db->prepare("SELECT * FROM users WHERE id=?");
$stmt->bind_param('i', $uid);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'change_password') {
        $current = $_POST['current_password'] ?? '';
        $new     = $_POST['new_password'] ?? '';
        $confirm = $_POST['confirm_password'] ?? '';

        if (!password_verify($current, $user['password'])) {
            setFlash('error', 'Current password is incorrect.');
        } elseif (strlen($new) < 8) {
            setFlash('error', 'New password must be at least 8 characters.');
        } elseif ($new !== $confirm) {
            setFlash('error', 'Passwords do not match.');
        } else {
            $hashed = password_hash($new, PASSWORD_DEFAULT);
            $db->query("UPDATE users SET password='$hashed' WHERE id=$uid");
            setFlash('success', 'Password changed successfully.');
        }

    } elseif ($action === 'toggle_2fa') {
        $enable = (int)($_POST['two_fa_enabled'] ?? 0);
        $db->query("UPDATE users SET two_fa_enabled=$enable WHERE id=$uid");
        setFlash('success', $enable ? '2FA enabled. You\'ll receive a code via email on each login.' : '2FA disabled.');
    }

    header('Location: /client/security.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Security — ProCRM</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="layout">
  <?php include __DIR__ . '/../includes/client-sidebar.php'; ?>
  <div class="main-content">
    <div class="topbar">
      <button class="topbar-toggle" id="sidebarToggle">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
      </button>
      <span class="topbar-title">Security & 2FA</span>
    </div>
    <div class="page">
      <?= renderFlash() ?>
      <div class="page-header"><h2>Security Settings</h2></div>

      <div style="max-width:600px;display:flex;flex-direction:column;gap:20px">

        <!-- 2FA Toggle -->
        <div class="card">
          <div class="card-header">
            <div class="card-title">Two-Factor Authentication</div>
            <span class="badge <?= $user['two_fa_enabled'] ? 'badge-approved' : 'badge-pending' ?>">
              <?= $user['two_fa_enabled'] ? 'Enabled' : 'Disabled' ?>
            </span>
          </div>
          <p style="color:var(--text-muted);font-size:14px;margin-bottom:20px">
            When enabled, you'll be required to enter a 6-digit code sent to your email (and WhatsApp if configured) each time you log in.
          </p>
          <form method="POST">
            <input type="hidden" name="action" value="toggle_2fa">
            <input type="hidden" name="two_fa_enabled" value="<?= $user['two_fa_enabled'] ? 0 : 1 ?>">
            <button type="submit" class="btn <?= $user['two_fa_enabled'] ? 'btn-danger' : 'btn-primary' ?>">
              <?= $user['two_fa_enabled'] ? 'Disable 2FA' : 'Enable 2FA' ?>
            </button>
          </form>
        </div>

        <!-- Change Password -->
        <div class="card">
          <div class="card-header"><div class="card-title">Change Password</div></div>
          <form method="POST">
            <input type="hidden" name="action" value="change_password">
            <div class="form-group">
              <label class="form-label">Current Password</label>
              <div style="position:relative;display:flex;align-items:center;">
                <input type="password" name="current_password" class="form-control" placeholder="Enter current password" style="padding-right:48px" required>
                <button type="button" class="password-toggle" style="position:absolute;right:12px;background:none;border:none;color:var(--text-muted);font-size:16px;cursor:pointer;">👁</button>
              </div>
            </div>
            <div class="form-row">
              <div class="form-group">
                <label class="form-label">New Password</label>
                <input type="password" name="new_password" class="form-control" placeholder="Min. 8 characters" required>
              </div>
              <div class="form-group">
                <label class="form-label">Confirm New Password</label>
                <input type="password" name="confirm_password" class="form-control" placeholder="Repeat new password" required>
              </div>
            </div>
            <button type="submit" class="btn btn-primary">Update Password</button>
          </form>
        </div>

        <!-- Session Info -->
        <div class="card">
          <div class="card-header"><div class="card-title">Session</div></div>
          <div style="display:flex;align-items:center;justify-content:space-between">
            <div>
              <div style="font-weight:600;font-size:14px">Current Session</div>
              <div class="text-muted" style="font-size:13px">Logged in as <?= htmlspecialchars($user['email']) ?></div>
            </div>
            <a href="/client/logout.php" class="btn btn-danger btn-sm">Logout</a>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
</body>
</html>
