<?php
require_once __DIR__ . '/../includes/functions.php';
requireAdmin();
$db = getDB();

// Badges
$pendingUsers  = $db->query("SELECT COUNT(*) FROM users WHERE status='pending'")->fetch_row()[0];
$pendingOrders = $db->query("SELECT COUNT(*) FROM orders WHERE status='pending'")->fetch_row()[0];

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$adminName   = $_SESSION['admin_name'] ?? 'Admin';
$initials    = strtoupper(substr($adminName, 0, 2));

function aNavItem($href, $icon, $label, $current, $badge = '') {
    $active = strpos($current, $href) !== false ? 'active' : '';
    $badgeHtml = $badge ? "<span class='sidebar-badge'>$badge</span>" : '';
    echo "<a href='/admin/$href' class='sidebar-item $active'>$icon <span>$label</span>$badgeHtml</a>";
}
?>
<div class="sidebar" id="sidebar">
  <div class="sidebar-logo">
    <div class="sidebar-logo-text">ProCRM</div>
    <div class="sidebar-logo-sub">Admin Panel</div>
  </div>
  <nav class="sidebar-nav">
    <div class="sidebar-section">Overview</div>
    <?php aNavItem('dashboard.php', '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="3" y="3" width="7" height="7" rx="1"/><rect x="14" y="3" width="7" height="7" rx="1"/><rect x="3" y="14" width="7" height="7" rx="1"/><rect x="14" y="14" width="7" height="7" rx="1"/></svg>', 'Dashboard', $currentPage); ?>

    <div class="sidebar-section">Management</div>
    <?php aNavItem('clients.php', '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M17 21v-2a4 4 0 00-4-4H5a4 4 0 00-4 4v2"/><circle cx="9" cy="7" r="4"/><path d="M23 21v-2a4 4 0 00-3-3.87M16 3.13a4 4 0 010 7.75"/></svg>', 'Clients', $currentPage, $pendingUsers > 0 ? $pendingUsers : ''); ?>
    <?php aNavItem('orders.php', '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg>', 'Orders', $currentPage, $pendingOrders > 0 ? $pendingOrders : ''); ?>

    <div class="sidebar-section">Configuration</div>
    <?php aNavItem('services.php', '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 2l2 7h7l-5.5 4 2 7L12 16l-5.5 4 2-7L3 9h7z"/></svg>', 'Services & Pricing', $currentPage); ?>
    <?php aNavItem('settings.php', '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="3"/><path d="M19.4 15a1.65 1.65 0 00.33 1.82l.06.06a2 2 0 010 2.83 2 2 0 01-2.83 0l-.06-.06a1.65 1.65 0 00-1.82-.33 1.65 1.65 0 00-1 1.51V21a2 2 0 01-4 0v-.09A1.65 1.65 0 009 19.4a1.65 1.65 0 00-1.82.33l-.06.06a2 2 0 01-2.83-2.83l.06-.06A1.65 1.65 0 004.68 15a1.65 1.65 0 00-1.51-1H3a2 2 0 010-4h.09A1.65 1.65 0 004.6 9a1.65 1.65 0 00-.33-1.82l-.06-.06a2 2 0 012.83-2.83l.06.06A1.65 1.65 0 009 4.68a1.65 1.65 0 001-1.51V3a2 2 0 014 0v.09a1.65 1.65 0 001 1.51 1.65 1.65 0 001.82-.33l.06-.06a2 2 0 012.83 2.83l-.06.06A1.65 1.65 0 0019.4 9a1.65 1.65 0 001.51 1H21a2 2 0 010 4h-.09a1.65 1.65 0 00-1.51 1z"/></svg>', 'Settings', $currentPage); ?>

    <div style="margin-top:auto;padding:0 0 4px">
      <a href="/admin/logout.php" class="sidebar-item" style="color:var(--danger)">
        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M9 21H5a2 2 0 01-2-2V5a2 2 0 012-2h4M16 17l5-5-5-5M21 12H9"/></svg>
        <span>Logout</span>
      </a>
    </div>
  </nav>
  <div class="sidebar-footer">
    <div class="sidebar-user">
      <div class="sidebar-avatar"><?= htmlspecialchars($initials) ?></div>
      <div class="sidebar-user-info">
        <div class="sidebar-user-name"><?= htmlspecialchars($adminName) ?></div>
        <div class="sidebar-user-role">Administrator</div>
      </div>
    </div>
  </div>
</div>
<div class="sidebar-overlay" id="sidebarOverlay"></div>
